#include <iostream>
#include <algorithm>
#include <string>
#include <vector>
#include <map>
using namespace std;

struct patient 
{
	int bloodgroup;
	int blood_required;
};

int map_bloodgroup(string bloodgroup)
{
	int int_bloodgroup;
	if (bloodgroup == "O")
		int_bloodgroup = 0;
	else if (bloodgroup == "A")
		int_bloodgroup = 1;
	else if (bloodgroup == "B")
		int_bloodgroup = 2;
	else if (bloodgroup == "AB")
		int_bloodgroup = 3;

	return int_bloodgroup;
}

void assign_blood(vector<int>& blood_storage, vector<patient>& patients, int i, int assigned_bloodgroup, vector<vector<int>>& assignment)
{
	int blood_assigned = min(blood_storage[assigned_bloodgroup], patients[i].blood_required);
	patients[i].blood_required -= blood_assigned;
	blood_storage[assigned_bloodgroup] -= blood_assigned;
	assignment[i][assigned_bloodgroup] += blood_assigned;
}

bool blood_requirements_met(vector<patient>& patients)
{
	for (int i = 0; i < patients.size(); i++)
	{
		if (patients[i].blood_required > 0) return false;
	}
	return true;
}

void print_assignment(vector<vector<int>>& assignment)
{
	for (int i = 0; i < assignment.size(); i++)
	{
		for (int j = 0; j < assignment[i].size(); j++)
			cout << assignment[i][j] << " ";
		cout << endl;
	}
}

int main()
{
	int patients_cnt; cin >> patients_cnt;
	vector<int> blood_storage(4);
	cin >> blood_storage[0] >> blood_storage[1] >> blood_storage[2] >> blood_storage[3];
	vector<vector<int>> assignment(patients_cnt, vector<int>(4));
	vector<patient> patients(patients_cnt);
	for (int i = 0; i < patients_cnt; i++)
	{
		string patient_bloodgroup; cin >> patient_bloodgroup;
		int patient_blood_required; cin >> patient_blood_required;
		int mapped_bloodgroup = map_bloodgroup(patient_bloodgroup);
		patients[i].bloodgroup = mapped_bloodgroup;
		patients[i].blood_required = patient_blood_required;
		assign_blood(blood_storage, patients, i, patients[i].bloodgroup, assignment);
	}


	for (int i = 0; i < patients_cnt && (blood_storage[map_bloodgroup("A")] > 0 || blood_storage[map_bloodgroup("B")] > 0); i++)
	{
		if (patients[i].bloodgroup == map_bloodgroup("AB"))
		{
			assign_blood(blood_storage, patients, i, map_bloodgroup("A"), assignment);
			assign_blood(blood_storage, patients, i, map_bloodgroup("B"), assignment);
		}
	}

	for (int i = 0; i < patients_cnt && blood_storage[map_bloodgroup("O")] > 0; i++)
	{
		assign_blood(blood_storage, patients, i, map_bloodgroup("O"), assignment);
	}

	if (blood_requirements_met(patients))
	{
		cout << "moguce" << endl;
		print_assignment(assignment);
	}
	else cout << "nemoguce" << endl;
}